package com.burhanstore.neonbubblequest.Utils.adapter

import android.app.Activity
import android.graphics.drawable.Drawable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.bumptech.glide.load.DataSource
import com.bumptech.glide.load.engine.GlideException
import com.bumptech.glide.request.RequestListener
import com.burhanstore.neonbubblequest.R
import com.burhanstore.neonbubblequest.Utils.model.LeaderModel


class LeaderAdapter
    (
    private val activity: Activity,
    private val trackList: List<LeaderModel>,
    private val onItemClick: (LeaderModel) -> Unit
) : RecyclerView.Adapter<LeaderAdapter
.TrackViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): TrackViewHolder {
        val view = LayoutInflater.from(activity).inflate(R.layout.leader_item, parent, false)
        return TrackViewHolder(view)
    }

    override fun onBindViewHolder(holder: TrackViewHolder, position: Int) {
        val item = trackList[position]


        Glide.with(holder.itemView.context)
            .load("${item.image}")
            .centerCrop()
            .listener(object : RequestListener<Drawable> {
                override fun onLoadFailed(
                    e: GlideException?,
                    model: Any?,
                    target: com.bumptech.glide.request.target.Target<Drawable>,
                    isFirstResource: Boolean
                ): Boolean {

                    return false
                }

                override fun onResourceReady(
                    resource: Drawable,
                    model: Any,
                    target: com.bumptech.glide.request.target.Target<Drawable>?,
                    dataSource: DataSource,
                    isFirstResource: Boolean
                ): Boolean {

                    return false
                }
            }).into(holder.userLogo)

        holder.totalRefer.text = "Refers :" + item.total_refer
        holder.Coin.text = item.total_earned
        holder.Rank.text = item.rank
        holder.UserName.text = item.name

    }

    override fun getItemCount(): Int = trackList.size

    inner class TrackViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val UserName: TextView = itemView.findViewById(R.id.UserName)
        val totalRefer: TextView = itemView.findViewById(R.id.totalRefer)
        val Coin: TextView = itemView.findViewById(R.id.Coin)
        val Rank: TextView = itemView.findViewById(R.id.Rank)
        val userLogo: ImageView = itemView.findViewById(R.id.userLogo)


    }
}